%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: calc_ref_conditions
%
% Scope:    calculate mean and standard deviation for each variable, 
%           plateau interval and gas type
%
% Input:    data (structure),
%           bindata (structure),
%           list of gas names (cell),
%           list of gas type "flags" (i.e., MPV positions) (double),
%           uncertainty table (double) (only required for initialization, not used here)
%
% Output:   "ref" structure containing mean/std deviations of raw data,
%           "binref" structure containing mean/std deviations of binned data,
%           overview figure
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [ref, binref, bindata] = calc_ref_conditions(data, bindata, gasnames, gastypeflag)

% create "flag" vector
for k=1:height(data.boundaries_idx)-1
    num=0;sum=0;
    for i=data.boundaries_idx(k,1):data.boundaries_idx(k+1,1)
        num=num+1;
        sum=sum+data.all(i,12);
    end
    data.flag(k,1)=round(sum/num);
end

bindata.flag=data.flag;

%% calc ref data

for k=1:height(data.boundaries_idx)-1
    for i=1:width(gastypeflag)
        if data.flag(k,1) == gastypeflag(1,i)
            ref.mean(k,:)=mean(data.plateau(data.boundaries_idx(k,1):data.boundaries_idx(k+1,1),:),'omitnan');
            ref.std(k,:)=std(data.plateau(data.boundaries_idx(k,1):data.boundaries_idx(k+1,1),:),'omitnan');
            ref.gastype(k,1)=gasnames(1,i);        
        end
    end
end

%% calc boundaries_idx for bindata

for i=1:height(data.boundaries_idx)
    check=abs(bindata.all(:,1)+bindata.start_time-data.all(data.boundaries_idx(i,1),1));
    [~, a]=min(check);
    bindata.boundaries_idx(i,1)=a; %NOTE: bindata.boundaries_idx defines the END of each interval -> Add +1 for the begininng of next interval
end

%% calc ref bin data

for k=1:height(bindata.boundaries_idx)-1
    for i=1:width(gastypeflag)
        if bindata.flag(k,1) == gastypeflag(1,i)
            binref.mean(k,:)=mean(bindata.all(bindata.boundaries_idx(k,1)+1:bindata.boundaries_idx(k+1,1),:),'omitnan');
            binref.std(k,:)=std(bindata.all(bindata.boundaries_idx(k,1)+1:bindata.boundaries_idx(k+1,1),:),'omitnan');
            binref.gastype(k,1)=gasnames(1,i);   
        end
    end
end

for k=1:width(bindata.all)
    for i=1:width(gastypeflag)
            binref.(gasnames{1,i})(1,k)=mean(bindata.(gasnames{1,i})(:,k),'omitnan');
            binref.(gasnames{1,i})(2,k)=std(bindata.(gasnames{1,i})(:,k),'omitnan');
    end
end

%% initialize uncertainty matrix

%     for i=1:width(gastypeflag)
%             uncert.(gasnames{1,i})=zeros(3,6);
%     end

end

